/*
 * Decompiled with CFR 0.152.
 */
package com.android.core.utils.params;

import com.android.core.utils.params.ParamType;
import java.util.function.Function;

public class Param {
    private final String sqlFieldName;
    private final String userSideParamName;
    private final String fieldAlias;
    private final String fieldTableName;
    private final ParamType paramType;
    private final Function<String, String> customQuery;

    private Param(String sqlFieldName, String userSideParamName, String fieldAlias, String fieldTableName, ParamType paramType, Function<String, String> customQuery) {
        this.sqlFieldName = sqlFieldName;
        this.userSideParamName = userSideParamName;
        this.fieldAlias = fieldAlias;
        this.fieldTableName = fieldTableName;
        this.paramType = paramType;
        this.customQuery = customQuery;
    }

    public String getSqlStandardValue(String value) {
        return this.paramType.normalizeValue(value);
    }

    public String getSqlFieldName() {
        return this.sqlFieldName;
    }

    public String getUserSideParamName() {
        return this.userSideParamName;
    }

    public String getFieldAlias() {
        return this.fieldAlias;
    }

    public String getFieldTableName() {
        return this.fieldTableName;
    }

    public ParamType getParamType() {
        return this.paramType;
    }

    public Function<String, String> getCustomQuery() {
        return this.customQuery;
    }
}

